# Quick Start (copy/paste)

## 0) Set credentials
Create a `.env` file from `env/.env.example` and set:
- `FIRMATO_CLIENT_ID`
- `FIRMATO_CLIENT_SECRET`

## 1) Get token
```bash
curl -X POST "https://firmato.eu/sign/public/api/v1/oauth/token" \
  -u "YOUR_CLIENT_ID:YOUR_CLIENT_SECRET" \
  -d "grant_type=client_credentials" \
  -d "scope=contracts:write contracts:read invites:send"
```

## 2) Create a contract (upload PDF)
```bash
curl -X POST "https://firmato.eu/sign/public/api/v1/contracts" \
  -H "Authorization: Bearer <token>" \
  -F "file=@document.pdf" \
  -F "title=My Document"
```

Response contains `contract_id`.

## 3) Add signers (parties)
```bash
curl -X POST "https://firmato.eu/sign/public/api/v1/contracts/<contract_id>/parties" \
  -H "Authorization: Bearer <token>" \
  -H "Content-Type: application/json" \
  -d '{
    "parties":[
      {"name":"Alice Doe","email":"alice@example.com"},
      {"name":"Bob Doe","email":"bob@example.com"}
    ]
  }'
```

Response contains `sign_url` per signer:
`https://firmato.eu/sign/public/sign.php?token=...`

## 4) Send invitations (optional)
```bash
curl -X POST "https://firmato.eu/sign/public/api/v1/contracts/<contract_id>/send" \
  -H "Authorization: Bearer <token>"
```

To re-send to all signers:
```bash
curl -X POST "https://firmato.eu/sign/public/api/v1/contracts/<contract_id>/send?force=1" \
  -H "Authorization: Bearer <token>"
```

## 5) Poll status
```bash
curl -X GET "https://firmato.eu/sign/public/api/v1/contracts/<contract_id>" \
  -H "Authorization: Bearer <token>"
```

## 6) Download final stamped PDF (after all signatures)
Use any signer token (typically the first) returned by `GET /contracts/{id}`:
`https://firmato.eu/sign/public/signed_download.php?token=...`

If the contract is not fully signed yet, `signed_download.php` may return HTTP 403.
