# firmato.eu – Developer Kit (External Signing API v1)

This kit contains everything a third-party development team needs to integrate **firmato.eu** signing into their own platform:
- HTML documentation (share as-is)
- OpenAPI (Swagger) specification
- Postman collection
- End-to-end code samples (Node.js, Python, PHP)
- .env template

## Base URLs (Production)
- API base: `https://firmato.eu/sign/public/api/v1/`
- Token: `POST https://firmato.eu/sign/public/api/v1/oauth/token`
- Recipient signing UI: `https://firmato.eu/sign/public/sign.php?token=...`
- Final stamped PDF download: `https://firmato.eu/sign/public/signed_download.php?token=...`

## Main workflow
1. Get an access token (OAuth2 `client_credentials`).
2. Upload the PDF → `contract_id`.
3. Add one or more signers (parties) → each signer gets a `sign_url`.
4. Send invitations (firmato.eu emails signers) **or** deliver the `sign_url` in your UX.
5. Poll status.
6. Download the final stamped PDF once all signers have signed.

See `QUICK_START.md` for copy/paste commands.
