<?php
/**
 * End-to-end sample (PHP 8.1+)
 * token -> upload pdf -> add parties -> send invitations -> get status
 */
$BASE = getenv('FIRMATO_BASE_URL') ?: 'https://firmato.eu/sign/public/api/v1';
$CLIENT_ID = getenv('FIRMATO_CLIENT_ID');
$CLIENT_SECRET = getenv('FIRMATO_CLIENT_SECRET');

if (!$CLIENT_ID || !$CLIENT_SECRET) { fwrite(STDERR, "Missing env vars\n"); exit(1); }

function http_post_form($url, $basicUser, $basicPass, $fields) {
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPAUTH => CURLAUTH_BASIC,
    CURLOPT_USERPWD => $basicUser . ":" . $basicPass,
    CURLOPT_POSTFIELDS => http_build_query($fields),
  ]);
  $out = curl_exec($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  if ($out === false) throw new Exception(curl_error($ch));
  curl_close($ch);
  if ($code < 200 || $code >= 300) throw new Exception("HTTP $code: $out");
  return json_decode($out, true);
}

function http_post_json($url, $token, $data) {
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => ["Authorization: Bearer $token", "Content-Type: application/json"],
    CURLOPT_POSTFIELDS => json_encode($data),
  ]);
  $out = curl_exec($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  if ($out === false) throw new Exception(curl_error($ch));
  curl_close($ch);
  if ($code < 200 || $code >= 300) throw new Exception("HTTP $code: $out");
  return json_decode($out, true);
}

function http_post_multipart($url, $token, $fields) {
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => ["Authorization: Bearer $token"],
    CURLOPT_POSTFIELDS => $fields,
  ]);
  $out = curl_exec($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  if ($out === false) throw new Exception(curl_error($ch));
  curl_close($ch);
  if ($code < 200 || $code >= 300) throw new Exception("HTTP $code: $out");
  return json_decode($out, true);
}

function http_get($url, $token) {
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => ["Authorization: Bearer $token"],
  ]);
  $out = curl_exec($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  if ($out === false) throw new Exception(curl_error($ch));
  curl_close($ch);
  if ($code < 200 || $code >= 300) throw new Exception("HTTP $code: $out");
  return json_decode($out, true);
}

$tok = http_post_form("$BASE/oauth/token", $CLIENT_ID, $CLIENT_SECRET, [
  'grant_type' => 'client_credentials',
  'scope' => 'contracts:write contracts:read invites:send'
]);
$token = $tok['access_token'];

$created = http_post_multipart("$BASE/contracts", $token, [
  'file' => new CURLFile(__DIR__ . '/document.pdf', 'application/pdf', 'document.pdf'),
  'title' => 'My Document'
]);
$cid = $created['contract_id'];

$parties = http_post_json("$BASE/contracts/$cid/parties", $token, [
  'parties' => [
    ['name'=>'Alice Doe','email'=>'alice@example.com']
  ]
]);

$inv = http_post_multipart("$BASE/contracts/$cid/send", $token, []);

$status = http_get("$BASE/contracts/$cid", $token);

echo "Contract ID: $cid\n";
echo "Signer URL example: " . ($status['links']['party_sign_urls'][0]['sign_url'] ?? '') . "\n";
echo "Stamped download URL (after all signatures): " . ($status['links']['stamped_download_url'] ?? '') . "\n";
